DROP PROCEDURE [hips].[PcehrMessageQueueOperationList]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon 
-- Create date:   13 Sept 2013
-- Description:   Lists the PcehrMessageQueues for the specific Time Period
-- =============================================
CREATE PROCEDURE [hips].[PcehrMessageQueueOperationList] 
(
	   @DateTimeFrom DATETIME
	   ,@DateTimeTo DATETIME
) AS
BEGIN

	SELECT  pmq.PcehrMessageQueueId, 
		pmq.DateCreated QueueItemDateCreated,
		pmq.QueueOperationId,
		qo.Description QueueOperationName,
		pmq.QueueStatusId,
		qs.Description QueueStatusName,
		h.HospitalId FacilityId,
		h.Description FacilityName,
		hp.PatientId,
		pmi.Ihi,
		e.EpisodeId,
		e.AdmissionDate AdmissionDateTime,
		pmq.SourceSystemSetId,
		LEN(CAST(pmq.Request AS NVARCHAR(MAX))) RequestSize,
        LEN(pmq.Request.value('declare namespace s="http://www.w3.org/2003/05/soap-envelope"; 
	        declare namespace x="urn:ihe:iti:xds-b:2007"; 
		    (/s:Envelope/s:Body/x:ProvideAndRegisterDocumentSetRequest/x:Document)[1]', 'VARBINARY(MAX)')) CDAPackageSize,
		pmq.Details,
		pmq.SerialisedObject
	FROM hips.PcehrMessageQueue As pmq WITH (NOLOCK) 
	INNER JOIN hips.QueueStatus As qs WITH (NOLOCK) ON qs.QueueStatusId = pmq.QueueStatusId
	INNER JOIN hips.QueueOperation AS qo WITH (NOLOCK) ON qo.QueueOperationId = pmq.QueueOperationId
	INNER JOIN hips.Episode	AS e WITH (NOLOCK) ON pmq.EpisodeId = e.EpisodeId
	INNER JOIN hips.HospitalPatient AS hp WITH (NOLOCK) ON e.PatientId = hp.PatientId
	INNER JOIN hips.Hospital AS h WITH (NOLOCK) ON hp.HospitalId = h.HospitalId
	INNER JOIN hips.PatientMasterIhi AS pmi WITH (NOLOCK) ON hp.PatientMasterId = pmi.PatientMasterId 
	WHERE (pmq.DateCreated >= @DateTimeFrom OR @DateTimeFrom IS NULL)
	AND (pmq.DateCreated <= @DateTimeTo OR @DateTimeTo IS NULL)
	ORDER BY pmq.DateCreated

END
GO

